# 8n8 Automation Hub (n8n on cPanel)

This is a **ready-to-upload** bundle to run **n8n** (no-code automations) on your **cPanel** hosting.

## ✅ What’s inside
- `server.js` — Launches n8n in cPanel Node.js App
- `package.json` — Declares dependencies + start script
- `.env.example` — Copy to `.env` and configure
- `workflows/website_to_telegram_facebook.json` — Starter workflow (import into n8n)

## 🚀 Quick Deploy (cPanel Node.js App)
1. **Upload** this folder (or the ZIP) to your hosting (e.g., `/home/USER/8n8-automation`).
2. In **cPanel → Setup Node.js App**:
   - Node.js version: **16 or higher**
   - Application root: `/home/USER/8n8-automation`
   - Application startup file: **server.js**
   - Environment variables (optional if you use `.env`):
     - `N8N_BASIC_AUTH_USER=admin`
     - `N8N_BASIC_AUTH_PASSWORD=<strong-password>`
     - `WEBHOOK_URL=https://automation.yourdomain.com/`
3. Click **Create** (or **Restart**) to start the app.
4. Visit `https://automation.yourdomain.com` → the **n8n editor** should load.

> Tip: Issue an SSL certificate for your subdomain in **cPanel → SSL/TLS → Manage** so your URL is HTTPS.

## 🔐 Security
- Change the **basic auth password** immediately (`.env` or cPanel env vars).
- Keep this folder **outside** your public `public_html` if possible.
- Consider **IP allowlisting** via your host if available.

## 🧩 Connect Your Channels (first time)
In the n8n editor:
- Create **Credentials** for:
  - **Telegram** (Bot token from @BotFather) — name it `My Telegram Bot`
  - **Facebook** (Page access via Meta Graph) — name it `My Facebook Page`
- Import the sample workflow: **workflows/website_to_telegram_facebook.json**
- Update nodes to use your credentials, chat IDs, page IDs, etc.
- Click **Activate**.

## 🧪 Starter Workflow Included
- **Trigger:** RSS feed (your website blog)
- **Action 1:** Send Telegram message (title + link)
- **Action 2:** Create Facebook Page post (title + link)

## 🛠 Common cPanel Notes
- Logs appear in the Node.js App **View Logs**.
- If the app doesn’t start, run `npm install` in the folder via cPanel Terminal.
- If your host provides a specific **PORT**, we pass it to n8n automatically.

## 📦 Updating n8n
- Via Terminal: `npm update n8n`
- Then restart the Node.js app.

## 🆘 Support
If something’s unclear, share a screenshot of your Node.js App settings and logs.
